<?php
require 'vendor/autoload.php'; // Adjust the path if necessary

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header('Content-Type: application/json'); // Set response header for JSON

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect and sanitize input data
    $sanitized_data = [];
    foreach ($_POST as $key => $value) {
        $sanitized_data[$key] = htmlspecialchars(strip_tags(trim($value)));
    }

    // Validate email
    if (!isset($sanitized_data['email']) || !filter_var($sanitized_data['email'], FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'message' => 'Invalid email format']);
        exit;
    }

    // Create a new PHPMailer instance
    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();                                           // Send using SMTP
        $mail->Host       = 'smtp.gmail.com';                    // Set the SMTP server to send through
        $mail->SMTPAuth   = true;                                // Enable SMTP authentication
        $mail->Username   = 'your-email@gmail.com';              // SMTP username
        $mail->Password   = 'your-password';                     // SMTP password (or app password)
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;        // Enable SSL encryption
        $mail->Port       = 465;                                  // TCP port to connect to

        // Recipients
        $mail->setFrom('your-email@gmail.com', 'Your Name');
        $mail->addAddress('recipient@example.com');              // Add a recipient

        // Content
        $mail->isHTML(false);                                    // Set email format to plain text
        $mail->Subject = "New message from " . ($sanitized_data['name'] ?? 'Unknown');
        
        // Build the email body
        $body = "You have received a new message:\n\n";
        foreach ($sanitized_data as $key => $value) {
            $body .= ucfirst($key) . ": $value\n";
        }

        $mail->Body = $body;

        // Send the email
        $mail->send();
        echo json_encode(['success' => true, 'message' => 'Email sent successfully!']); // Success response
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => "Email sending failed: {$mail->ErrorInfo}"]); // Error response
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}
?>
